DECLARE @BancoDados VARCHAR(50);
SET @BancoDados = (SELECT nome_banco_dados FROM prc_bancos_dados WHERE tipo_banco_dados = 1);

IF LEN(@BancoDados) > 0
BEGIN
    -- Montar consulta dinâmica para verificar a existência da coluna no banco correto
    DECLARE @SQL NVARCHAR(MAX);
    SET @SQL = '
    IF NOT EXISTS (
        SELECT 1
        FROM ' + @BancoDados + '.INFORMATION_SCHEMA.COLUMNS
        WHERE TABLE_NAME = ''PDV_VD_NFCE_ARQ_DANFE''
          AND COLUMN_NAME = ''FLAG_TRIAGEM_NOTA''
    )
    BEGIN
        ALTER TABLE ' + @BancoDados + '..PDV_VD_NFCE_ARQ_DANFE ADD FLAG_TRIAGEM_NOTA INT DEFAULT 0;
    END';

    -- Executar a consulta dinâmica
    EXEC sp_executesql @SQL;
END
ELSE
BEGIN
    PRINT 'Não foi possível retornar o banco de dados para criação do campo';
END;